/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

// Edit Convenience Functions

#include <StdAfx.h>
#include "funcheader.h"
#include "CConvenienceExports.h"

HRESULT GetDeleteLinesInput(ISet **objectSet1)
{
	START_METHOD("GetDeleteLinesInput")

	HRESULT status = CONV_SUCCESS;

	double topLeftX = -0.1;
	double topLeftY = 0.1;

	double bottomRightX = 0.1;
	double bottomRightY = -0.1;

	ISet *rectangle1 = NULL;
	status = CreateRectangle(topLeftX, topLeftY, bottomRightX, bottomRightY, &rectangle1);
	CHECK_RETURN_STATUS(status)

	*objectSet1 = rectangle1;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetDeleteLinesInput")
}

HRESULT GetOffsetChainInput(ISet **objectSet1, double *offsetDistance, long *offsetDirection)
{
	
	START_METHOD("GetOffsetChainInput")

	HRESULT status = CONV_SUCCESS;

	double topLeftX = -0.1;
	double topLeftY = 0.1;

	double bottomRightX = 0.1;
	double bottomRightY = -0.1;

	ISet *rectangle1 = NULL;
	status = CreateRectangle(topLeftX, topLeftY, bottomRightX, bottomRightY, &rectangle1);
	CHECK_RETURN_STATUS(status)

	*objectSet1 = rectangle1;
	*offsetDistance = 0.02;
	*offsetDirection = 1;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetOffsetChainInput")
}

HRESULT GetTranslateObjectsInput(double *xDistance, double *yDistance, ISet **objectset1)
{
	START_METHOD("GetTranslateObjectsInput")

	HRESULT status = CONV_SUCCESS;

	double topLeftX = -0.1;
	double topLeftY = 0.1;
	
	double bottomRightX = 0.1;
	double bottomRightY = -0.1;

	ISet *rectangle1 = NULL;
	status = CreateRectangle(topLeftX, topLeftY, bottomRightX, bottomRightY, &rectangle1);
	CHECK_RETURN_STATUS(status)
	
	*xDistance = -0.05;
	*yDistance = -0.05;
	*objectset1 = rectangle1;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetTranslateObjectsInput")	
}

HRESULT GetRotateObjectsInput(double *angle, ISet **objectSet1)
{
	START_METHOD("GetRotateObjectsInput")

	HRESULT status = CONV_SUCCESS;

	double topLeftX = -0.1;
	double topLeftY = 0.1;

	double bottomRightX = 0.1;
	double bottomRightY = -0.1;

	ISet *rectangle1 = NULL;
	status = CreateRectangle(topLeftX, topLeftY, bottomRightX, bottomRightY, &rectangle1);
	CHECK_RETURN_STATUS(status)
	
	*angle = 45;
	*objectSet1 = rectangle1;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetRotateObjectsInput")
	
}

HRESULT GetScaleObjectsInput(double *scaleFactor, ISet **objectSet1)
{
	START_METHOD("GetScaleObjectsInput")

	HRESULT status = CONV_SUCCESS;

	double topLeftX = -0.1;
	double topLeftY = 0.1;

	double bottomRightX = 0.1;
	double bottomRightY = -0.1;

	ISet *rectangle1 = NULL;
	status = CreateRectangle(topLeftX, topLeftY, bottomRightX, bottomRightY, &rectangle1);
	CHECK_RETURN_STATUS(status)

	*scaleFactor = 0.5;
	*objectSet1 = rectangle1;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetScaleObjectsInput")
}

HRESULT GetRectangularDuplicateInput(double *xNumber, double *yNumber, double *xSpacing,
																		 double *ySpacing, ISet **objectSet1)
{
	START_METHOD("GetRectangularDuplicateInput")

	HRESULT status = CONV_SUCCESS;
		
	double centerX = -0.1;
	double centerY = -0.1;
	double radius = 0.02;

	ILine *circle1 = NULL;
	status = CreateCircle(centerX, centerY, radius, &circle1);
	CHECK_RETURN_STATUS(status)
	
	*xNumber = 2;
	*yNumber = 2;
	*xSpacing = 0.1;
	*ySpacing = 0.1;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	// Create a set of lines
	ISet *aLineSet1 = NULL;
	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&aLineSet1);
	CHECK_RETURN_STATUS(status)

	// Add those two temporary lines ( created above ) to the set
	status = aLineSet1->AddMember(circle1);
	CHECK_RETURN_STATUS(status)

	// Apply AutoConstrain on the set of lines
	status = activeWorkplane->AutoConstrain(CAST(IObjectOrSet, aLineSet1));
	CHECK_RETURN_STATUS(status)

	*objectSet1 = aLineSet1;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetRectangularDuplicateInput")
	
}

HRESULT GetCircularDuplicateInput(long *number, double *angle, BOOL *isTotalAngle,
																	ISet **objectSet1)
{
	START_METHOD("GetCircularDuplicateInput")

	HRESULT status = CONV_SUCCESS;

	double centerX = 0.07;
	double centerY = 0;
	double radius = 0.02;

	ILine *circle1 = NULL;
	status = CreateCircle(centerX, centerY, radius, &circle1);
	CHECK_RETURN_STATUS(status)

	*number = 6;
	*angle = 360;
	*isTotalAngle = TRUE;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	// Create a set of lines

	ISet *aLineSet1 = NULL;
	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&aLineSet1);
	CHECK_RETURN_STATUS(status)

	// Add those two temporary lines ( created above ) to the set
	status = aLineSet1->AddMember(circle1);
	CHECK_RETURN_STATUS(status)

	// Apply AutoConstrain on the set of lines
	status = activeWorkplane->AutoConstrain(CAST(IObjectOrSet, aLineSet1));
	CHECK_RETURN_STATUS(status)

	*objectSet1 = aLineSet1;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetCircularDuplicateInput")
	
}

HRESULT GetMirrorInXInput(ISet **objectSet1)
{
	START_METHOD("GetMirrorInXInput")

	HRESULT status = CONV_SUCCESS;
	
	double startX = -0.1;
	double startY = 0.1;
	double endX = 0.1;
	double endY = 0.1;

	ILine *line1 = NULL;
	status = CreateLine(startX, startY, endX, endY, &line1) ;
	CHECK_RETURN_STATUS(status)

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	// Create a set of lines

	ISet *aLineSet1 = NULL;
	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&aLineSet1);
	CHECK_RETURN_STATUS(status)

	// Add those two temporary lines ( created above ) to the set
	status = aLineSet1->AddMember(line1);
	CHECK_RETURN_STATUS(status)

	// Apply AutoConstrain on the set of lines
	status = activeWorkplane->AutoConstrain(CAST(IObjectOrSet, aLineSet1));
	CHECK_RETURN_STATUS(status)

	*objectSet1 = aLineSet1;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetMirrorInXInput")
}

HRESULT GetMirrorInYInput(ISet **objectSet1)
{
	START_METHOD("GetMirrorInYInput")

	HRESULT status = CONV_SUCCESS;
	
	double startX = 0.1;
	double startY = -0.1;
	double endX = 0.1;
	double endY = 0.1;

	ILine *line1 = NULL;
	status = CreateLine(startX, startY, endX, endY, &line1);
	CHECK_RETURN_STATUS(status)

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	// Create a set of lines

	ISet *aLineSet1 = NULL;
	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&aLineSet1);
	CHECK_RETURN_STATUS(status)

	// Add those two temporary lines ( created above ) to the set
	status = aLineSet1->AddMember(line1);
	CHECK_RETURN_STATUS(status)

	// Apply AutoConstrain on the set of lines
	status = activeWorkplane->AutoConstrain(CAST(IObjectOrSet, aLineSet1));
	CHECK_RETURN_STATUS(status)

	*objectSet1 = aLineSet1;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetMirrorInYInput")
}

HRESULT GetMirrorInBothInput(ISet **objectSet1)
{
	START_METHOD("GetMirrorInBothInput")

	HRESULT status = CONV_SUCCESS;

	double startX = 0.05;
	double startY = 0.05;
	double endX = 0.1;
	double endY = 0.1;

	ILine *line1 = NULL;
	status = CreateLine(startX, startY, endX, endY, &line1);
	CHECK_RETURN_STATUS(status)

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	// Create a set of lines

	ISet *aLineSet1 = NULL;
	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&aLineSet1);
	CHECK_RETURN_STATUS(status)

	// Add those two temporary lines ( created above ) to the set
	status = aLineSet1->AddMember(line1);
	CHECK_RETURN_STATUS(status)

	// Apply AutoConstrain on the set of lines
	status = activeWorkplane->AutoConstrain(CAST(IObjectOrSet, aLineSet1));
	CHECK_RETURN_STATUS(status)

	*objectSet1 = aLineSet1;

	status = CommitToProDESKTOP("Input");
	CHECK_RETURN_STATUS(status)

	END_METHOD("GetMirrorInBothInput")
}
